// CleanFinding Extension - New Tab Script

const searchForm = document.getElementById('searchForm');
const searchInput = document.getElementById('searchInput');
const searchType = document.getElementById('searchType');
const settingsLink = document.getElementById('settingsLink');

// Handle search
searchForm.addEventListener('submit', (e) => {
  e.preventDefault();
  const query = searchInput.value.trim();
  const type = searchType.value;
  
  if (query) {
    const searchUrl = `https://cleanfinding.com/search.html?q=${encodeURIComponent(query)}&type=${type}`;
    window.location.href = searchUrl;
  }
});

// Settings link
settingsLink.addEventListener('click', (e) => {
  e.preventDefault();
  chrome.runtime.openOptionsPage();
});

// Focus search input
searchInput.focus();
