// CleanFinding Extension - Popup Script

// Elements
const searchInput = document.getElementById('searchInput');
const searchButton = document.getElementById('searchButton');
const settingsBtn = document.getElementById('settingsBtn');
const newTabBtn = document.getElementById('newTabBtn');
const blockedCount = document.getElementById('blockedCount');

// Load blocked count
function updateBlockedCount() {
  chrome.storage.local.get('blockedCount', (data) => {
    blockedCount.textContent = data.blockedCount || 0;
  });
}

updateBlockedCount();

// Search function
function performSearch() {
  const query = searchInput.value.trim();
  if (query) {
    const searchUrl = `https://cleanfinding.com/search.html?q=${encodeURIComponent(query)}&type=search`;
    chrome.tabs.create({ url: searchUrl });
    window.close();
  }
}

// Event listeners
searchButton.addEventListener('click', performSearch);

searchInput.addEventListener('keypress', (e) => {
  if (e.key === 'Enter') {
    performSearch();
  }
});

settingsBtn.addEventListener('click', () => {
  chrome.runtime.openOptionsPage();
  window.close();
});

newTabBtn.addEventListener('click', () => {
  chrome.tabs.create({ url: 'chrome://newtab' });
  window.close();
});

// Focus search input
searchInput.focus();
