// CleanFinding Extension - Settings Script

// Elements
const blockTrackers = document.getElementById('blockTrackers');
const blockInappropriate = document.getElementById('blockInappropriate');
const enforceSafeSearch = document.getElementById('enforceSafeSearch');
const blockAnalytics = document.getElementById('blockAnalytics');
const resetStats = document.getElementById('resetStats');
const blockedCount = document.getElementById('blockedCount');
const successMessage = document.getElementById('successMessage');

// Load settings
function loadSettings() {
  chrome.storage.sync.get({
    blockTrackers: true,
    blockInappropriate: true,
    enforceSafeSearch: true,
    blockAnalytics: true
  }, (settings) => {
    blockTrackers.checked = settings.blockTrackers;
    blockInappropriate.checked = settings.blockInappropriate;
    enforceSafeSearch.checked = settings.enforceSafeSearch;
    blockAnalytics.checked = settings.blockAnalytics;
  });

  // Load statistics
  chrome.storage.local.get('blockedCount', (data) => {
    blockedCount.textContent = data.blockedCount || 0;
  });
}

// Save settings
function saveSettings() {
  const settings = {
    blockTrackers: blockTrackers.checked,
    blockInappropriate: blockInappropriate.checked,
    enforceSafeSearch: enforceSafeSearch.checked,
    blockAnalytics: blockAnalytics.checked
  };

  chrome.storage.sync.set(settings, () => {
    // Show success message
    successMessage.style.display = 'block';
    setTimeout(() => {
      successMessage.style.display = 'none';
    }, 3000);
  });
}

// Event listeners
blockTrackers.addEventListener('change', saveSettings);
blockInappropriate.addEventListener('change', saveSettings);
enforceSafeSearch.addEventListener('change', saveSettings);
blockAnalytics.addEventListener('change', saveSettings);

resetStats.addEventListener('click', () => {
  chrome.storage.local.set({ blockedCount: 0 }, () => {
    blockedCount.textContent = '0';
    chrome.action.setBadgeText({ text: '' });
    
    successMessage.textContent = '✓ Statistics reset!';
    successMessage.style.display = 'block';
    setTimeout(() => {
      successMessage.style.display = 'none';
      successMessage.textContent = '✓ Settings saved successfully!';
    }, 3000);
  });
});

// Initialize
loadSettings();
